from django.shortcuts import render
from rest_framework import viewsets
from .models import Warehouse
from .warehouse_serializer import WarehouseSerializer
from rest_framework.permissions import IsAuthenticated


# Create your views here.
class WarehouseViewSet(viewsets.ModelViewSet):
    queryset = Warehouse.objects.all()
    serializer_class = WarehouseSerializer
    permission_classes = [IsAuthenticated]

    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Warehouse.objects.filter(user=user).order_by("-id")