from django.db import models
from settings.models import Settings
from django.contrib.auth.models import User
import datetime
import uuid

# Create your models here.
class Warehouse(models.Model):
    reference = models.CharField(max_length=50,unique=True)
    label = models.CharField(max_length=200, unique=True)
    devise = models.CharField(max_length=3)
    address = models.CharField(max_length=255,null=True, blank=True)
    email = models.CharField(max_length=255, null=True, blank=True)
    phone = models.CharField(max_length=255, null=True, blank=True)
    is_activated = models.BooleanField(default=True)
    country = models.CharField(max_length=500, null=True, default="")
    city = models.CharField(max_length=500, null=True, default="")
    logo_company = models.ImageField(upload_to='medias/', null=True, default="logo/logo.png")
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    created_at = models.DateTimeField(default=datetime.datetime.now)

    def __str__(self):
        return self.label

