from django.contrib.auth.models import User
from rest_framework import viewsets, status, filters

from kappi.tasks import send_email_of_created_account
from settings.models import Settings
from subscription.models import Subscription
from .user_serializer import UserSerializer

from rest_framework.response import Response
from rest_framework.authtoken.models import Token
from rest_framework.authtoken.views import ObtainAuthToken
from django.shortcuts import get_object_or_404
from rest_framework.decorators import action
from rest_framework import status

from django.contrib.auth.hashers import make_password

class UserViewSet(viewsets.ModelViewSet):
    queryset = User.objects.all()
    serializer_class = UserSerializer
    search_fields = ['id']
    filter_backends = (filters.SearchFilter,)

    def create(self, request):

        if "username" in request.data and "password" in request.data and "email" in request.data:

            if User.objects.filter(username=request.data.get('username')).exists():

                return Response({
                    "detail-en": f"Duplicate entry '{request.data.get('username')}' for key username",
                    "detail-fr": f"le nom d'utilisateur '{request.data.get('username')}' est déjà pris"
                }, status=status.HTTP_200_OK)

            elif User.objects.filter(email=request.data.get('email')).exists():
                return Response({
                    "detail-en": f"Duplicate entry '{request.data.get('email')}' for key email",
                    "detail-fr": f"L'adresse email '{request.data.get('email')}' est déjà utilisée"
                }, status=status.HTTP_200_OK)

            else:
                user = User.objects.create(username=request.data.get('username'),
                                           password=make_password(request.data.get('password'), salt=None,
                                                                  hasher='default'),
                                           first_name=request.data.get('first_name'),
                                           last_name=request.data.get('last_name'),
                                           email=request.data.get('email'))
                user.save()
                subscription_creation = Subscription.objects.create(
                    user=user,
                    subscription_api_id="trial-30" + user.username,
                    method="trial",
                    subscription_state=True
                )
                subscription_creation.save()
                # send_email_of_created_account(user.email, user.username)
                token = Token.objects.create(user=user)
                settings = Settings.objects.create(user=user, name_compagny=user.username)
                settings.save()
                subscriptions = Subscription.objects.filter(user=user)
                if_days_exist_subscription = False

                for subscription in subscriptions:

                    if subscription.check_subscription > 0:
                        if_days_exist_subscription = True
                        pass

                return Response({
                    "detail": "success",
                    'token': token.key,
                    'id': user.id,
                    'username': user.username,
                    'password': user.password,
                    'first_name': user.first_name,
                    'last_name': user.last_name,
                    'email': user.email,
                    'subscription': if_days_exist_subscription
                }, status=status.HTTP_200_OK)

        else:
            return Response(
                {'username': "required", 'password': "required", 'email': "required", "first_name": "required",
                 "last_name": "required"})

    def retrieve(self, request, pk=None):

        if pk is not None:
            user = get_object_or_404(User, id=pk)
            token, created = Token.objects.get_or_create(user=user)
            subscriptions = Subscription.objects.filter(user=user)
            if_days_exist_subscription = False
            for subscription in subscriptions:
                if subscription.check_subscription > 0:
                    if_days_exist_subscription = True
                    pass
            return Response({
                "detail": "success",
                'token': token.key,
                'id': user.id,
                'username': user.username,
                'first_name': user.first_name,
                'last_name': user.last_name,
                'password': user.password,
                'email': user.email,
                'subscription': if_days_exist_subscription
            })

    @action(methods=['GET','POST'], detail=False)
    def check_username_and_email(self,request):
        if request.data.get('email') and request.data.get('username'):
            user_check_if_is_exist = User.objects.filter(username=request.data.get('username'), email=request.data.get('email')).exists()
            if user_check_if_is_exist:
                return Response({
                    "success": True,
                    "detail": "username and email already exist"
                }, status=status.HTTP_200_OK)
            else:
                return Response({
                    "success": False,
                    "detail": "username and email do not exist"
                }, status=status.HTTP_200_OK)
        else:
            return Response({"detail": "Invalid email or username"}, status=status.HTTP_200_OK)

    @action(methods=['GET','POST'], detail=False)
    def reset_password(self, request):
        try:
            username = request.data.get('username')
            new_password = request.data.get('new_password')

            if not username or not new_password:
                return Response({
                    "success": False,
                    "detail": "new_password and username are required"
                }, status=status.HTTP_400_BAD_REQUEST)

            # Chercher l'utilisateur par nom d'utilisateur
            user = User.objects.get(username=username)
            
            # Modifier et sauvegarder le mot de passe
            user.set_password(new_password)
            user.save()
            
            return Response({"success": True, "detail": "Password changed successfully"}, status=status.HTTP_200_OK)
        except User.DoesNotExist:
            return Response({
                "success": False,
                "detail": "User not found"
            }, status=status.HTTP_404_NOT_FOUND)
        except Exception as e:
            # Gestion des exceptions génériques
            return Response({
                "success": False,
                "detail": f"An error occurred: {str(e)}"
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class AuthTokenCustomize(ObtainAuthToken):
    def post(self, request, *args, **kwargs):
        serializer = self.serializer_class(data=request.data,
                                           context={'request': request})
        serializer.is_valid(raise_exception=True)
        user = serializer.validated_data['user']
        token, created = Token.objects.get_or_create(user=user)
        subscriptions = Subscription.objects.filter(user=user)
        if_days_exist_subscription = False
        for subscription in subscriptions:
            if subscription.check_subscription > 0:
                if_days_exist_subscription = True
                pass

        return Response({
            "detail": "success",
            'token': token.key,
            'id': user.id,
            'username': user.username,
            'first_name': user.first_name,
            'last_name': user.last_name,
            'password': user.password,
            'email': user.email,
            'subscription': if_days_exist_subscription
        })
