from django.db import models
from django.contrib.auth.models import User
from settings.models import Settings

# Create your models here.
class Supplier(models.Model):
    name = models.CharField(max_length=200)
    phone = models.CharField(max_length=20)
    email = models.EmailField(max_length=200, null=True, blank=True, default="")
    address = models.TextField(null=True, blank=True, default="")
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)

    def __str__(self):
        return self.name
    

    