from django.http import JsonResponse
from django.shortcuts import render
from rest_framework import viewsets
from .models import SubCategory
from .subcategory_serializer import SubCategorySerializer
from rest_framework.permissions import IsAuthenticated
from settings.models import Settings
from category.models import Category
from rest_framework.decorators import action
from django.shortcuts import get_object_or_404


# Create your views here.
class SubCategoryViewSet(viewsets.ModelViewSet):
    queryset = SubCategory.objects.all()
    serializer_class = SubCategorySerializer
    permission_classes = [IsAuthenticated]

    def create(self, request, *args, **kwargs):
        data = request.data
        if data.get('label') and data.get('category'):
            if SubCategory.objects.filter(label=data.get('label')).exists():
                return JsonResponse({
                    "detail": "subcategory already exists"
                })
            else:
                try:
                    settings = Settings.objects.get(user=request.user)
                except Settings.DoesNotExist:
                    return JsonResponse({
                        "detail": "Organisation for the user do not exist"
                    }, status=400)

                try:
                    category = Category.objects.get(id=data.get('category'))
                except Category.DoesNotExist:
                    return JsonResponse({
                        "detail": "Category do not exist"
                    }, status=400)

                subcategory = SubCategory.objects.create(
                    user=request.user,
                    label=data.get('label'),
                    category=category,
                    organisation=settings
                )

                subcategory.save()

            return JsonResponse({
                "detail": "success",
                "id": subcategory.id,
                "label": subcategory.label,
                "category": subcategory.category.label,
                "user": subcategory.user.username,
                "organisation": subcategory.organisation.name_compagny
            })
        else:
            return JsonResponse({
                "label": "is required",
                "category": "is required"
            })

    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return SubCategory.objects.filter(user=user).order_by("-id")

    @action(methods=["POST"], detail=False)
    def save_multiple_subcategories(self, request):
        if request.data.get('category') and isinstance(request.data.get('subcategory'), list) and len(
                request.data.get('subcategory')) > 0:
            organisation = get_object_or_404(Settings, user=request.user)
            category = get_object_or_404(Category, id=request.data.get('category'))
            subcat_list_exist = []
            subcat_list_saved = []
            for subcat in request.data.get('subcategory'):
                if_subcat_exist = SubCategory.objects.filter(label=subcat['label']).exists()
                if if_subcat_exist == True:
                    subcat_list_exist.append(subcat['label'])
                else:
                    subcategory = SubCategory.objects.create(
                        label=subcat['label'],
                        user=request.user,
                        organisation=organisation,
                        category=category
                    )
                    subcategory.save()
                    subcat_list_saved.append(subcat['label'])
            return JsonResponse({
                'exist': subcat_list_exist,
                'saved': subcat_list_saved
            })
        else:
            return JsonResponse({
                'category': 'is required',
                'subcategory': 'list of subcategory is required', }
            )
