from django.contrib.auth.models import User
from django.db import models

# Create your models here.


class Settings(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    name_compagny = models.CharField(max_length=200,null=True,default="")
    logo_company = models.ImageField(upload_to='medias/',null=True, default="logo/logo.png")
    register_number_company = models.CharField(max_length=200,null=True,default="")
    address_company = models.CharField(max_length=200,null=True, default="")
    email = models.CharField(max_length=200,null=True, default="")
    country = models.CharField(max_length=200,null=True,default="")
    business_phone_number = models.CharField(max_length=20,null=True, default="")
    payment_method = models.TextField(null=True, default="")
    devise = models.CharField(max_length=10,null=True,default="usd")
    subscription_state = models.BooleanField(default=False)
    code_country = models.CharField(max_length=100,null=True,default="")
    footer_invoice = models.TextField(null=True,default="")
    signature = models.TextField(null=True, default="")
    id_national = models.CharField(max_length=200, null=True, blank=True, default="")
    impot_number = models.CharField(max_length=200, null=True, blank=True, default="")
    exchange_rate = models.DecimalField(default=0,max_digits=12, decimal_places=2)
    # Jeton d'authentification pour l'API DGI
    dgi_api_token = models.CharField(max_length=512, null=True, blank=True, default="")

    def __str__(self):
        return self.name_compagny

