from django.db import models
import datetime
from product.models import Product
from django.contrib.auth.models import User
from settings.models import Settings
import jsonfield
import uuid

# Create your models here.
class Sale(models.Model):
    reference = models.CharField(max_length=50,default=uuid.uuid4())
    product = jsonfield.JSONField(default=list)
    status = models.BooleanField(default=True)
    discount = models.DecimalField(max_digits=5, decimal_places=2, null=True, blank=True, default=0.00)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)
    create_at = models.DateField(default=datetime.date.today())

    def __str__(self):
        return self.reference
