from django.db import models
from django.utils.timezone import now
from django.contrib.auth.models import User

from customer.models import Customer
from settings.models import Settings
from subcategory.models import SubCategory
from supplier.models import Supplier
from warehouse.models import Warehouse
from category.models import Category
import uuid

# Create your models here.
class Product(models.Model):
    STOCK_CHOICES = [
        ('stock', 'Stock'),
        ('no-stock', 'No Stock'),
    ]
    code = models.CharField(default=str(uuid.uuid4())[:6],max_length=12)
    label = models.CharField(max_length=200)
    description = models.TextField(null=True, default="")
    retention_period = models.DateTimeField(null=True, blank=True, default=now)
    stock = models.CharField(max_length=8, choices=STOCK_CHOICES, default='stock')
    selling_price = models.DecimalField(max_digits=12, decimal_places=2)
    purchase_price = models.DecimalField(max_digits=12, decimal_places=2)
    tags = models.CharField(max_length=200, null=True, default="")
    supplier = models.ForeignKey(Supplier, on_delete=models.CASCADE)
    quantity = models.IntegerField()
    color = models.CharField(max_length=100,null=True, blank=True, default="")
    weight = models.DecimalField(max_digits=12, decimal_places=2,null=True, blank=True, default=0.00)
    unit = models.CharField(default=0, max_length=255)
    size = models.DecimalField(max_digits=12, decimal_places=2, null=True, blank=True, default=0.00)
    width = models.DecimalField(max_digits=12, decimal_places=2,null=True, blank=True, default=0.00)
    height = models.DecimalField(max_digits=12, decimal_places=2,null=True, blank=True, default=0.00)
    length = models.DecimalField(max_digits=12, decimal_places=2,null=True, blank=True, default=0.00)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    subcategory = models.ForeignKey(SubCategory, on_delete=models.CASCADE)
    category = models.ForeignKey(Category, on_delete=models.CASCADE, null=True)
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)
    warehouse = models.ForeignKey(Warehouse, on_delete=models.CASCADE, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    def __str__(self):
        return self.label
    

