from .models import Notice
from .notice_serializer import NoticeSerializer
from rest_framework import viewsets, serializers
from rest_framework.permissions import IsAuthenticated
from django.http import JsonResponse

# Create your views here.

class NoticeViewSet(viewsets.ModelViewSet):
    queryset = Notice.objects.all()
    serializer_class = NoticeSerializer
    permission_classes = [IsAuthenticated]

    def create(self, request):
        if request.data.get('title') and request.data.get('stars'):

            if request.data.get('content') is None:
                content_notice = ''
            else:
                content_notice = request.data.get('content')

            notice = Notice.objects.create(
                title=request.data.get('title'),
                content=content_notice,
                stars=request.data.get('stars'),
                user=request.user
            )
            notice.save()
            return JsonResponse({
                "detail": "success",
                "id": notice.id,
                "title": notice.title,
                "content": notice.content,
                "stars": notice.stars,
                "user": notice.user.id,
            })
        else:
            return JsonResponse({
                "title": ["title is required"],
                "content": ["content is optional"],
                "stars": ["stars is required"],
            })
