from django.db import models
from django.contrib.auth.models import User
# Create your models here.


class Notice(models.Model):
    title = models.CharField(max_length=200)
    content = models.TextField(null=True, blank=True)
    stars = models.IntegerField(default=0, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    user = models.ForeignKey(User, on_delete=models.CASCADE)

    class Meta:
        ordering = ['-created_at']

    def __str__(self):
        return self.title