import datetime
import threading
import time

import schedule
from django.core import mail
from django.core.mail import send_mail
from django.db.models import Count
from django.template import loader

from invoice.models import Invoice
from kappi.settings import EMAIL_HOST_USER
from settings.models import Settings


def send_email_of_not_paid_invoice_to_client():
    try:
        connection = mail.get_connection()
        connection.open()
        invoices = Invoice.objects.annotate(invoice_number=Count('id'))
        today = datetime.date.today()
        invoice_of_customer_with_email = []
        for invoice in invoices:
            if invoice.customer.email and invoice.paid == False and invoice.check_if_invoice_expired == 0 or invoice.check_if_invoice_expired < 0:
                settings = Settings.objects.get(user=invoice.user)
                invoice_of_customer_with_email.append(invoice.customer.email)
                html_message = loader.render_to_string(
                    'email/email_user.html', locals())
                send_mail('Rappel du retard de la facture', 'test envoi', EMAIL_HOST_USER,
                          [invoice.customer.email], fail_silently=True, html_message=html_message)
                return "True"
            else:
                return "False"

    except NameError:
        return NameError


def run_continuously(interval=1):
    """Continuously run, while executing pending jobs at each
    elapsed time interval.
    @return cease_continuous_run: threading. Event which can
    be set to cease continuous run. Please note that it is
    *intended behavior that run_continuously() does not run
    missed jobs*. For example, if you've registered a job that
    should run every minute and you set a continuous run
    interval of one hour then your job won't be run 60 times
    at each interval but only once.
    """
    cease_continuous_run = threading.Event()

    class ScheduleThread(threading.Thread):
        @classmethod
        def run(cls):
            while not cease_continuous_run.is_set():
                schedule.run_pending()
                time.sleep(interval)

    continuous_thread = ScheduleThread()
    continuous_thread.start()
    return cease_continuous_run


def send_email_of_created_account(email,username):
    try:
        html_message = loader.render_to_string(
            'email/email_of_create_account.html', locals())
        send_mail('Création de votre compte!', '', EMAIL_HOST_USER,
                  [email], fail_silently=True, html_message=html_message)
    except NameError:
        return False

def send_email_of_reset_password(email):
    try:
        connection = mail.get_connection()
        connection.open()
        html_message = loader.render_to_string(
            'email/email_user.html', locals())
        send_mail('Rappel du retard de la facture', 'test envoi', EMAIL_HOST_USER,
                  [invoice.customer.email], fail_silently=True, html_message=html_message)
    except NameError:
        return NameError