# Generated by Django 6.0.1 on 2026-01-23 14:56

import datetime
import django.db.models.deletion
import jsonfield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('customer', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PaymentMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=200)),
                ('description', models.CharField(max_length=200, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('items', jsonfield.fields.JSONField(default=list)),
                ('paid', models.BooleanField(default=False)),
                ('send', models.BooleanField(default=False)),
                ('invoice_total_amount', models.DecimalField(decimal_places=1, default=0, max_digits=12)),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('create_invoice_at', models.DateField(default=datetime.date(2026, 1, 23))),
                ('invoice_expire_at', models.DateField(default=datetime.date(2026, 1, 23))),
                ('year_of_invoice', models.IntegerField(default=2026)),
                ('month_of_invoice', models.IntegerField(default=1)),
                ('tva_rate', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('subtotal', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('footer_note', models.TextField(blank=True, default='', null=True)),
                ('proforma_state', models.BooleanField(default=False)),
                ('signature', models.TextField(default='', null=True)),
                ('model_invoice', models.IntegerField(default=0, null=True)),
                ('labor', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('label_model', models.TextField(blank=True, default='')),
                ('payment_rules', models.TextField(blank=True, default='', null=True)),
                ('currency', models.CharField(default='usd', max_length=10)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='customer.customer')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='invoice.paymentmethod')),
            ],
        ),
    ]
