import ast
from rest_framework import serializers
from invoice.models import Invoice


class InvoiceSerializer(serializers.ModelSerializer):
    items = serializers.SerializerMethodField()
    customer = serializers.ReadOnlyField(source='customer.name')
    email_customer = serializers.ReadOnlyField(source='customer.email')
    phone_customer = serializers.ReadOnlyField(source='customer.phone')

    class Meta:
        model = Invoice
        fields = '__all__'

    def get_items(self, obj):
        str_convert = obj.items
        array_convert = []
        for i in range(len(str_convert)):
            str_convert[i] = ast.literal_eval(str_convert[i])
            array_convert.append(str_convert[i])
        return array_convert
