from django.http import JsonResponse
from rest_framework import viewsets
from rest_framework.permissions import IsAuthenticated

from customer.customer_serializer import CustomerSerializer
from customer.models import Customer, EmailSendCustomer
from rest_framework.decorators import action
from rest_framework.response import Response
from customer.utils import do_email_to_customer
from settings.models import Settings

from django.core import mail
from django.core.mail import send_mail
from django.db.models import Count
from django.template import loader
from rest_framework import status
from invoice.models import Invoice
from kappi.settings import EMAIL_HOST_USER

# Create your views here.

class CustomerViewSet(viewsets.ModelViewSet):
    queryset = Customer.objects.all()
    serializer_class = CustomerSerializer
    permission_classes = [IsAuthenticated]
    
    def create(self, request):
        champs_obligatoires = ['name', 'phone', 'email', 'address', 'city', 'state', 'post', 'country', 'label']
        champs_manquants = [champ for champ in champs_obligatoires if not request.data.get(champ)]

        if champs_manquants:
            return JsonResponse(
                {champ: "est requis" for champ in champs_manquants},
                status=status.HTTP_400_BAD_REQUEST
            )

        # Vérifier si un client avec delete_state=False existe déjà
        existing_customer = Customer.objects.filter(
            name=request.data.get('name'),
            user=request.user,
            delete_state=False
        ).first()

        if existing_customer:
            return JsonResponse(
                {"detail": "Un client avec ce nom existe déjà."},
                status=status.HTTP_400_BAD_REQUEST
            )

        # Vérifier si un client supprimé existe déjà
        deleted_customer = Customer.objects.filter(
            name=request.data.get('name'),
            user=request.user,
            delete_state=True
        ).first()

        if deleted_customer:
            # Réactiver le client supprimé
            deleted_customer.phone = request.data.get('phone')
            deleted_customer.email = request.data.get('email')
            deleted_customer.address = request.data.get('address')
            deleted_customer.city = request.data.get('city')
            deleted_customer.state = request.data.get('state')
            deleted_customer.post = request.data.get('post')
            deleted_customer.country = request.data.get('country')
            deleted_customer.label = request.data.get('label')
            deleted_customer.delete_state = False
            deleted_customer.save()
            message = "Client réactivé et mis à jour."
            customer = deleted_customer
        else:
            # Créer un nouveau client
            customer = Customer.objects.create(
                user=request.user,
                name=request.data.get('name'),
                phone=request.data.get('phone'),
                email=request.data.get('email'),
                address=request.data.get('address'),
                city=request.data.get('city'),
                state=request.data.get('state'),
                post=request.data.get('post'),
                country=request.data.get('country'),
                label=request.data.get('label'),
            )
            message = "Client créé avec succès."

        return JsonResponse({
            "detail": message,
            "id": customer.id,
            "name": customer.name,
            "phone": customer.phone,
            "email": customer.email,
            "address": customer.address,
            "city": customer.city,
            "state": customer.state,
            "post": customer.post,
            "country": customer.country,
            "label": customer.label,
        }, status=status.HTTP_201_CREATED)

    def get_queryset(self):
        """
        Retourner une liste de tous les clients pour l'utilisateur
        actuellement authentifié où `delete_state` est False.
        """
        user = self.request.user
        return Customer.objects.filter(user=user, delete_state=False)
        

    @action(methods=['GET','POST'], detail=False)
    def change_delete_state_customer(self, request, *args, **kwargs):

        if request.data.get('id') and request.data.get('delete_state') == True or request.data.get(
                'delete_state') == False:

            customer = Customer.objects.get(user=request.user, id=request.data.get('id'))
            customer.delete_state = request.data.get('delete_state')
            customer.save()
            serializer = CustomerSerializer([customer], many=True)
            return JsonResponse(serializer.data[0], safe=False)

        else:
            return Response({
                "id": "id for invoice is required",
                "delete_state": "is required true or false  value"
            })

    @action(methods=['POST'], detail=False)
    def send_email_to_customer(self, request):
        if request.data.get('emails'):
            count_rows_sent = 0
            count_rows_not_sent = 0
            email_sender = Settings.objects.get(user=request.user)
            for email_address in request.data.get('emails'):
                email_receiver = Customer.objects.get(id=int(email_address['customer_id']))

                try:
                    html_message = loader.render_to_string(
                        'email/email_of_customers.html', locals())
                    if send_mail("subject", 'test', EMAIL_HOST_USER,
                                 [email_receiver.email], fail_silently=False, html_message=html_message):
                        count_rows_sent += 1
                        print("email sent")
                        return Response({
                            "status": True,

                        })
                except Exception as e:
                    print(e)
                    return Response({
                        "status": "error",
                        "details": str(e)
                    })

            return Response({
                "status": "success",
                "count_rows_sent": count_rows_sent,
                "count_rows_not_sent": count_rows_not_sent

            })

    @action(detail=False, methods=['POST'])
    def save_multiple_customers(self, request):
        """
        This view should save items from a JSON array to the database
        for the currently authenticated user.
        """
        user = self.request.user
        data = request.data.get('customers')
        if not data:
            return Response({"error": "No customers found in the JSON array."})
        else:
            for item in data:
                customer = Customer.objects.create(
                    user=user,
                    name=item['name'],
                    phone=item['phone'],
                    email=item['email'],
                    address=item['address'],
                    city=item['city'],
                    state=item['state'],
                    post=item['post'],
                    country=item['country'],
                    label=item['label'],
                )
                customer.save()
            return JsonResponse({"success": "customers saved successfully."})
            
