from django.contrib.auth.models import User
from django.db import models
import datetime


# Create your models here.


class Customer(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    name = models.CharField(max_length=50, default="")
    phone = models.CharField(max_length=15, null=True, default="")
    email = models.CharField(max_length=200, null=True, default="")
    address = models.CharField(max_length=200, null=True, default="")
    city = models.CharField(max_length=200, null=True, default="")
    state = models.CharField(max_length=200, null=True, default="")
    post = models.CharField(max_length=200, null=True, default="")
    country = models.CharField(max_length=500, null=True, default="")
    delete_state = models.BooleanField(default=False)
    label = models.CharField(max_length=200, null=True, default="", blank=True)
    created_at = models.DateTimeField(default=datetime.datetime.now)

    def __str__(self):
        return self.name


class EmailSendCustomer(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    customer = models.ForeignKey(Customer, on_delete=models.CASCADE, null=True)
    email_sender = models.CharField(max_length=255)
    email_receiver = models.CharField(max_length=255)
    label = models.CharField(max_length=255, null=True, blank=True, default="")
    subject = models.CharField(max_length=255)
    message = models.TextField()
    is_sent = models.BooleanField(default=False)

    def __str__(self):
        return self.subject
