from django.shortcuts import render
from rest_framework import viewsets
from django.http import JsonResponse
from .models import Category
from .category_serializer import CategorySerializer
from rest_framework.permissions import IsAuthenticated
from settings.models import Settings
from django.db.models import Count,Sum
from rest_framework.response import Response
from rest_framework.decorators import action

# Create your views here.
class CategoryViewSet(viewsets.ModelViewSet):
    queryset = Category.objects.all()
    serializer_class = CategorySerializer
    permission_classes =[IsAuthenticated]

    def create(self, request, *args, **kwargs):
        data = request.data
        if data.get('label'):
            if Category.objects.filter(label=data.get('label')).exists():
                return JsonResponse({
                    "detail": "category already exists"
                })
            else:
                try:
                    settings = Settings.objects.get(user=request.user)
                except Settings.DoesNotExist:
                    return JsonResponse({
                        "detail": "Organisation for the user do not exist"
                    }, status=400)
                
                category = Category.objects.create(
                    user=request.user,
                    label=data.get('label'),
                    organisation=settings
                )
                category.save()
            return JsonResponse({
                "detail": "success",
                "id": category.id,
                "label": category.label,
                "user": category.user.username,
                "organisation": category.organisation.name_compagny
            })
        else:
            return JsonResponse({
                "label": "is required"
                })

    def get_queryset(self):
        """
        Retourne le queryset filtré pour l'utilisateur courant.
        """
        user = self.request.user
        return Category.objects.filter(user=user)

    def list(self, request, *args, **kwargs):
        """
        Retourne la liste des catégories de l'utilisateur courant avec le nombre de produits.
        """
        user = request.user
        categories = Category.objects.filter(user=user).values('id','label','user','organisation').annotate(count_product=Count('product__id'))
        list_categories = list(categories)
        return JsonResponse({"result": list_categories}, safe=False)

    @action(methods=["POST"], detail=False)
    def save_multiple_categories(self, request):
        if isinstance(request.data.get('category'), list) and len(request.data.get('category')) > 0:
            try:
                organisation = get_object_or_404(Settings, user=request.user)
                cat_list_exist = []
                cat_list_saved = []
                for cat in request.data.get('category'):
                    if_subcat_exist = Category.objects.filter(user=request.user,label=cat['label']).exists()
                    if if_subcat_exist == True:
                        cat_list_exist.append(cat['label'])
                    else:
                        category = Category.objects.create(
                            label=cat['label'],
                            user=request.user,
                            organisation=organisation
                        )
                        category.save()
                        cat_list_saved.append(cat['label'])

                return JsonResponse({
                    'exist': cat_list_exist,
                    'saved': cat_list_saved
                })
            except:
                return JsonResponse({'details': 'categories no saved'})
        else:
            return JsonResponse({'category': 'list of category is required'})

